[![The Open Source Phasor Data Concentrator](../openPDC_Logo.png)](../openPDC_Home.md)

|   |   |   |   |
|---|---|---|---|
| **[Grid Protection Alliance](http://www.gridprotectionalliance.org)** | **[openPDC Project on GitHub](https://github.com/GridProtectionAlliance/openPDC)** | **[openPDC Wiki Home](../openPDC_Home.md)** | **[Documentation](../openPDC_Documentation_Home.md)** |

# Custom Action Adapters - Unpublished Data

## CodePlex Discussion 433859 Archive

**Feb 20, 2013 at 8:24:08 PM [patpentz](http://www.codeplex.com/site/users/view/patpentz)**

I am using both the OneSecondFrequencyAverager action adapter, provided by GPA, and also I have created two other action adapters, one to calculate one-second voltage phase angles and one to calculate one-second voltage phase angle slopes. My two adapters follow the example of the OneSecondFrequencyAverager, in that one adapter handled multiple input voltage phase angle measurements, writing to multiple output measurements. Even when I only use the provided OneSecondFrequencyAverager, with only 9 frequency measurements, I quickly get the error message:  `[<adapter name>]` There are `<n>` seconds of unpublished data in the action adapter concentration queue.  The number of seconds climbs from the value 2 or 3 to 6 or 7, which is when I disable the adapter(s). When I use my own adapters, the problem is worse, and quicker to climb.  The openPDC doesn't seem to use much CPU... is this a problem? Is there some configuration that can alleviate this problem? Or...

** Feb 20, 2013 at 8:26:59 PM [patpentz](http://www.codeplex.com/site/users/view/patpentz)**

By the way, I also am using about 7 PowerCalculation adapters to calculate MW/MVAR values, and 7 Dynamic Calculation adapters to calculate the MVA from the previous. Also, two other Dynamic Calculation adapters for miscellaneous use. And, about 3000 alarms.

** Feb 20, 2013 at 8:29:03 PM [patpentz](http://www.codeplex.com/site/users/view/patpentz)**

and more... I am using 1.5.179 of openPDC

**Feb 21, 2013 at 1:58:54 PM [patpentz](http://www.codeplex.com/site/users/view/patpentz)**

I may have figured out my problem.  I misunderstood the use of 'waitHandleNames' and 'WaitHandleReleaseName'. I was passing a value for 'waitHandleNames' for adapters that should have had 'WaitHandleReleaseName' - or so I now believe. My new assumsion: action adapters that only work on 'first-level' measurements (incoming phase angles, magnitudes, frequencies, statistics) should not have 'waitHandleNames', but may have 'WaitHandleReleaseName'. If any action adapter creates output measurements to be used by subsequent action adapters, it should have a value for 'WaitHandleReleaseName'. Action adapters that need to wait for calculated measurements by previous action adapters need to pass 'waitHandleNames', using the values of 'WaitHandleReleaseName' for those previous action adapters.

Is this correct? Some GPA-provided action adapters, such as OneSecondFrequencyAverager and PowerCalculator don't advertise the use of 'WaitHandleReleaseName'. If passed to those adapters, will the handle be released?

**Feb 21, 2013 at 2:41:24 PM [staphen](http://www.codeplex.com/site/users/view/staphen) Coordinator**

Hi patpentz,

The external event handles are only relevant if an adapter is modifying an existing set of measurements. For example, say you have a data quality action adapter that is modifying the state flags of measurements that were generated by an input adapter. If another adapter needs to pass that data on to a historian, in order to guarantee that the state flags changes to show up there, the data quality adapter needs to provide a signal to the historian adapter to indicate that it is done processing that set of measurements. This is what the external event handles were designed for.

Most adapters will create their own measurements, rather than modifying existing ones. Since the very existence of those measurements can be used as the trigger for other adapters to process them, then there is no need for a signaling mechanism like external event handles. As a result, the WaitHandleReleaseName connection string property does not exist by default, and most adapters do not support it.

Also note that since the development of the feature, we have discovered a number of shortcomings with the external event handle system that can potentially cause problems in complex scenarios. As of openPDC v1.5.192, we have removed external event handles and included a new feature which we've called "Queue and Notify" that addresses this problem.

Stephen

**Feb 21, 2013 at 2:56:30 PM [staphen](http://www.codeplex.com/site/users/view/staphen) Coordinator**

This may also be worth noting to clear up any confusion. The dynamic calculator does mistakenly specify a WaitHandleReleaseName in its connection string. This parameter is not needed, and there is no reason for other adapters to specify WaitHandleNames in order to receive the measurements generated by the dynamic calculator.

**Feb 21, 2013 at 4:00:24 PM [patpentz](http://www.codeplex.com/site/users/view/patpentz)**

thanks. I am easily confused... I will no longer use either waitHandleNames or WaitHandleReleaseName

**Feb 26, 2013 at 6:37:44 PM [patpentz](http://www.codeplex.com/site/users/view/patpentz)**

I just read about the new 'Dependency' mechanism. Thanks!

I assume that, as stated above, this only affects adapters that modify existing measurements. That is, an adapter needing measurements newly created by other adapters will not need any synchronization. If this is wrong, please let me know.

**Feb 26, 2013 at 6:52:11 PM [staphen](http://www.codeplex.com/site/users/view/staphen) Coordinator**

Yep, that is correct.

---

Oct 5, 2015 - Migrated from [CodePlex](http://openpdc.codeplex.com/discussions/433859) by [ajs](https://github.com/ajstadlin)

---

Copyright 2015 [Grid Protection Alliance](http://www.gridprotectionalliance.org)
